
browser.runtime.onMessage.addListener((request, sender, sendResponse) => {
    if(summaryURL != window.location.href) { return; }
    debugmode && console.log('(summarymode)', request.cmd);
    switch(request.cmd) {
        case 'populateSummary':

            populateSummary(request, sendResponse);

            return true;
    }
});

function populateSummary(request, sendResponse) {
    let summaryText = request.summarizeResult.summary;
    let domain = request.snoopResult.domain;
    let title = request.snoopResult.title;

    readermodeTemplateHTML.then(html => {
        if(!document.querySelector('#Container')) {
            document.body.innerHTML = html;

            let title = request.snoopResult.title;
            let summary = request.summarizeResult.summary;
            let href = request.snoopResult.href;

            let summaryHTML = `
            <div id="SummaryContainer">
                <div id="TitleSection">
                    <h1 data-wol-readable="false">Content Summary</h1>
                    <h2 data-wol-readable="false">${title}</h2>
                    <div class="domain">
                        <div><img src="https://api.bretlester.com/favicons/${domain}" style="width:16px;height:16px"/> <span data-wol-readable="false">&nbsp;<a style="color:var(--accent-color)" target="_blank" href="${href}">${domain}</a></span></div>
                    </div>
                </div>
                <div id="SummarySection">${summary}</div>
            </div>
            `;

            document.getElementById('Content').innerHTML = summaryHTML;
            document.getElementsByTagName('title')[0].innerHTML = 'SUMMARY: '+title;
            togglePlayer(true);

            sendResponse && sendResponse();
        }
    });
}