(function () {
  if (self === self.top) {
    const file = chrome.runtime.getURL(`js/gDocsCanvasFallback.js`);
    const documentElement = document.documentElement;

    const link_docs = document.createElement('link');
    link_docs.id = "_docs_force_html_by_ext";
    documentElement.appendChild(link_docs);

    const link = document.createElement('link');
    link.href = file;
    link.rel = 'preload';
    link.as = 'script';
    link.onload = () => {
      link.remove();
    };
    documentElement.appendChild(link);

    const script = document.createElement('script');
    script.type = 'text/javascript';
    script.async = false;
    script.defer = false;
    script.src = file;
    script.setAttribute('data-ext-id', chrome.runtime.id);
    script.onload = () => {
      setTimeout(() => {
        script.remove();
      }, 300);
    };
    documentElement.appendChild(script);
  }
})();